# WiFiBoyMini MicroPython Melody Engine Demo
# Nov 25, 2017, Derek Lai, derek@wifiboy.org
# "Super Mario 2 Theme" with buzzer tricks

import machine, time

try:
    if snd: snd.deinit()
except:
    pass

machine.Pin(17,3).value(1)
snd=machine.PWM(machine.Pin(25, 3))
snd.duty(0)

env1=[90,90,90,0,0,0,0,0]
env2=[90,60,30,20,15,10,5,0]
env3=[20,90,20,80,20,60,5,0]
env4=[90,50,30,20,10,0,0,0]

f=[round(110*2**(x/12)) for x in range(51)]

mel1=[23,22,0,21,18,0,15,13,0,12,11,0,0,23,0,0,11,0,0,0,0,0,
      23,0,16,20,0,23,0,0,16,20,0,23,15,19,23,27,0,25,0,0,0,
      0,0,0,23,0,14,18,0,23,0,0,14,18,0,23,0,0,14,18,0,23,17,
      20,21,27,0,25,0,0,0,0,0,27,28,0,27,28,0,25,0,0,28,27,0,
      25,23,0,22,23,0,20,0,0,17,18,0,20,21,0,20,21,0,15,0,0,
      20,18,0,16,0,0,0,0,0,0,0,0,0,0,0,0]

mel2=[16,0,20,0,0,0,23,0,0,25,0,28,0,0,0,0,0,0,25,0,0,16,18,
      0,20,18,0,20,18,0,13,0,0,18,0,0,13,18,13,18,13,18,13,18,
      0,0,0,0,0,0,20,18,0,20,18,0,20,0,0,25,0,0,23,25,0,23,20,
      0,18,16,0,20,0,0,11,16,11,16,11,16,11,16,20,0,0,0,23,19,
      0,15,0,13,0,11,0,0,0,20,0,0,0,23,0,0,25,0,28,0,0,0,0,0,
      0,25,0,23,20,16,18,20,18,0,20,18,0,13,0,0,18,0,0,13,18,
      13,18,13,18,13,18,0,0,0,0,20,18,0,20,18,0,20,0,0,25,0,0,
      23,25,0,23,25,0,23,20,0,16,0,0,0,0,0,10,11,0,12,13,0,16,
      0,0,0,0,0,16,0,0,0,16,0,20,0,0,21,19,0,20,21,0,19,20,0,
      27,0,0,0,24,0,0,21,0,0,20,0,18,20,18,16,15,0,16,18,0,16,
      15,0,16,0,0,0,0,0,16,15,0,0,16,0,0,0,0,18,0,0,0,17,0,0,
      18,0,25,0,0,0,22,0,0,23,0,0,25,0,0,27,0,0,0,0,0,25,0,0,
      0,0,0,24,0,0,0,0,0,23,0,18,15,0,11]

def play(dt, mel, env, shift): # melody engine
    for i in range(0, len(mel)):
        if (mel[i]!=0):
            snd.freq(f[mel[i]+shift])
            ei=0
        for j in range(0, 4):
            if (ei<8):
                snd.duty(env[ei])
            time.sleep(dt)
            ei=ei+1

wb.cls()
wb.colors(0xfe0f, 0xfe0f)
wb.str("WiFiBoy", 10, 10, 1, 2)
wb.str("Melody Engine Demo", 10, 35, 2, 1)
wb.str("Super Mario 2 Theme", 10, 60, 2, 1)

play(0.025, mel1, env1, 0)
play(0.025, mel2, env2, 0)
play(0.025, mel1, env3, 0)
play(0.025, mel2, env4, 0)
snd.duty(0)
0)
